/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CcLinkSlave_Public.h $
   Last Modification:
    $Id: CcLinkSlave_Public.h 21190 2012-01-03 09:34:40Z Eric $

    $Author: Eric $
    $Modtime: 19.09.08 11:40 $
    $Revision: 20 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CcLink Slave
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     20         03.01.12    ES
         Extended diagnostic information

     19         05.09.11    ES
         Added get IO information request

     18         14.04.10    ES
        Corrected definition for minimum and maximum number of stations

     17         01.02.10    ES
        Added definition for number of bit and register data 
     
     16         14.01.10    ES
        Added parameter for I/O points and types

     15         19.09.08    ES
        Added limited station address

     14         08.01.08    ES
        Support of CC-Link Version V2.0
        Corrected size of send and receive buffer
        Added extended diagnostic data

     10         19.11.07    ES
        Removed model code parameter

     8          17.11.07    ES
        Added definitions for number of occupied station for IO device

     6          14.11.07    ES
        Added parameter for Version 2

     3          31.10.07    ES
        Created

**************************************************************************************/
/**
 * @file CcLinkSlave_Public.h
 *  CcLink Slave - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __CCLINK_SLAVE_PUBLIC_H
#define __CCLINK_SLAVE_PUBLIC_H

#define CCLINK_SLAVE_INITIALIZE_REQ               0x00004500
#define CCLINK_SLAVE_INITIALIZE_CNF               0x00004501

#define CCLINK_SLAVE_REGISTER_REQ                 0x00004502
#define CCLINK_SLAVE_REGISTER_CNF                 0x00004503

#define CCLINK_SLAVE_GET_BUFFER_HANDLE_REQ        0x00004504
#define CCLINK_SLAVE_GET_BUFFER_HANDLE_CNF        0x00004505

#define CCLINK_SLAVE_SET_BUS_PARAM_REQ            0x00004506
#define CCLINK_SLAVE_SET_BUS_PARAM_CNF            0x00004507

#define CCLINK_SLAVE_STARTSTOP_REQ                0x00004508
#define CCLINK_SLAVE_STARTSTOP_CNF                0x00004509

#define CCLINK_SLAVE_GET_CCL_STATUS_REQ           0x0000450A
#define CCLINK_SLAVE_GET_CCL_STATUS_CNF           0x0000450B

#define CCLINK_SLAVE_CHANGE_SLAVE_STATUS_REQ      0x0000450C
#define CCLINK_SLAVE_CHANGE_SLAVE_STATUS_CNF      0x0000450D

#define CCLINK_SLAVE_GET_BUS_PARAM_REQ            0x0000450E
#define CCLINK_SLAVE_GET_BUS_PARAM_CNF            0x0000450F

#define CCLINK_SLAVE_GET_IO_INFO_REQ              0x00004510
#define CCLINK_SLAVE_GET_IO_INFO_CNF              0x00004511

#define CCLINK_SLAVE_STATE_CHANGE_IND             0x0000451E
#define CCLINK_SLAVE_STATE_CHANGE_RES             0x0000451F

#define CCLINK_SLAVE_SET_WATCHDOG_FAIL_REQ        0x000045AA
#define CCLINK_SLAVE_SET_WATCHDOG_FAIL_CNF        0x000045AB

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'CcLink Slave'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 CCLINK_SLAVE_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(CCLINK_SLAVE_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define CCLINK_SLAVE_QUEUE_NAME   "QUE_CCLSLAVE"

/** @} */

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__CCLINK_SLAVE_PACKET)
#endif

/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_BUS_PARAM_Ttag</code> */
typedef struct CCLINK_SLAVE_BUS_PARAM_Ttag
  CCLINK_SLAVE_BUS_PARAM_T;

#define CCLINK_SLAVE_MIN_SLAVE_STATION_ADDR  0x00000001L
#define CCLINK_SLAVE_MAX_SLAVE_STATION_ADDR  0x00000040L

#define CCLINK_SLAVE_BAUD_156K          0x00000000L   /* 156kBaud  */
#define CCLINK_SLAVE_BAUD_625K          0x00000001L   /* 625kBaud  */
#define CCLINK_SLAVE_BAUD_2500K         0x00000002L   /* 2500kBaud */
#define CCLINK_SLAVE_BAUD_5M            0x00000003L   /* 5MBaud    */
#define CCLINK_SLAVE_BAUD_10M           0x00000004L   /* 10MBaud   */
#define CCLINK_SLAVE_MAX_BAUD           CCLINK_SLAVE_BAUD_10M

#define CCLINK_SLAVE_STATION_TYPE_IO_DEVICE     0x00000000L
#define CCLINK_SLAVE_STATION_TYPE_REMOTE_DEVICE 0x00000001L

#define CCLINK_SLAVE_NO_STATION_IO_DEVICE       0x00000001L

#define CCLINK_SLAVE_LIMITED_SLAVE_STATION_ADDR   0x00000020L

#define CCLINK_SLAVE_MIN_NO_STATION_REMOTE_DEVICE 0x00000001L
#define CCLINK_SLAVE_MAX_NO_STATION_REMOTE_DEVICE 0x00000004L

#define CCLINK_SLAVE_CCLINK_VERSION_1   0x00000000L
#define CCLINK_SLAVE_CCLINK_VERSION_2   0x00000001L

#define CCLINK_SLAVE_CCLINK_EXTENSION_CYCLE_SINGLE    0x00000000L
#define CCLINK_SLAVE_CCLINK_EXTENSION_CYCLE_DOUBLE    0x00000001L
#define CCLINK_SLAVE_CCLINK_EXTENSION_CYCLE_QUADRUPLE 0x00000002L
#define CCLINK_SLAVE_CCLINK_EXTENSION_CYCLE_OCTUPLE   0x00000003L

#define CCLINK_SLAVE_IO_TYPES_POINTS_DEFAULT                  0x00000000L
#define CCLINK_SLAVE_IO_TYPES_POINTS_MIXED_DEP_ON_STATION     0x00000001L
#define CCLINK_SLAVE_IO_TYPES_POINTS_MIXED_8POINTS            0x00000002L
#define CCLINK_SLAVE_IO_TYPES_POINTS_MIXED_16POINTS           0x00000003L
#define CCLINK_SLAVE_IO_TYPES_POINTS_MIXED_32POINTS           0x00000004L
#define CCLINK_SLAVE_IO_TYPES_POINTS_INPUT_DEP_ON_STATION     0x00000005L
#define CCLINK_SLAVE_IO_TYPES_POINTS_INPUT_8POINTS            0x00000006L
#define CCLINK_SLAVE_IO_TYPES_POINTS_INPUT_16POINTS           0x00000007L
#define CCLINK_SLAVE_IO_TYPES_POINTS_INPUT_32POINTS           0x00000008L
#define CCLINK_SLAVE_IO_TYPES_POINTS_OUTPUT_DEP_ON_STATION    0x00000009L
#define CCLINK_SLAVE_IO_TYPES_POINTS_OUTPUT_8POINTS           0x0000000AL
#define CCLINK_SLAVE_IO_TYPES_POINTS_OUTPUT_16POINTS          0x0000000BL
#define CCLINK_SLAVE_IO_TYPES_POINTS_OUTPUT_32POINTS          0x0000000CL
#define CCLINK_SLAVE_IO_TYPES_POINTS_COMPOSITE_DEP_ON_STATION 0x0000000DL
#define CCLINK_SLAVE_IO_TYPES_POINTS_COMPOSITE_8POINTS        0x0000000EL
#define CCLINK_SLAVE_IO_TYPES_POINTS_COMPOSITE_16POINTS       0x0000000FL
#define CCLINK_SLAVE_IO_TYPES_POINTS_COMPOSITE_32POINTS       0x00000010L

#define CCLINK_SLAVE_MAX_IO_TYPES_POINTS  CCLINK_SLAVE_IO_TYPES_POINTS_COMPOSITE_32POINTS


__PACKED_PRE struct CCLINK_SLAVE_BUS_PARAM_Ttag
{
  TLR_UINT32    ulSlaveStationAddr;
  TLR_UINT32    ulBaudRate;

  TLR_UINT32    ulStationType;
  TLR_UINT32    ulNoStation;

  TLR_UINT32    ulCcLinkVersion;
  TLR_UINT32    ulExtensionCycle;

  TLR_UINT32    ulIoTypesPoints;
  TLR_BOOLEAN32 fHoldClrMode;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_ADD_PARAM_Ttag</code> */
typedef struct CCLINK_SLAVE_ADD_PARAM_Ttag
  CCLINK_SLAVE_ADD_PARAM_T;

#define CCLINK_SLAVE_MAX_VENDOR_CODE    0x0000FFFFL
#define CCLINK_SLAVE_MAX_MODEL_TYPE     0x000000FFL
#define CCLINK_SLAVE_MAX_SW_VERSION     0x0000003FL

__PACKED_PRE struct CCLINK_SLAVE_ADD_PARAM_Ttag
{
  TLR_UINT32 ulVendorCode;
  TLR_UINT32 ulModelType;
  TLR_UINT32 ulSwVersion;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_SLAVE_STATE_Ttag</code> */
typedef struct CCLINK_SLAVE_SLAVE_STATE_Ttag
  CCLINK_SLAVE_SLAVE_STATE_T;

#define CCLINK_SLAVE_STATE_FLAG_RDY        0x00000001L
#define CCLINK_SLAVE_STATE_FLAG_RUN        0x00000002L
#define CCLINK_SLAVE_STATE_FLAG_COM        0x00000004L
#define CCLINK_SLAVE_STATE_FLAG_BUS_ON     0x00000008L
#define CCLINK_SLAVE_STATE_FLAG_COMM_ERROR 0x00000010L

__PACKED_PRE struct CCLINK_SLAVE_SLAVE_STATE_Ttag
{
  TLR_UINT32  ulCcLinkState;   /* CC-Link state */

  TLR_UINT32  ulFlags;
  TLR_UINT32  ulErrorCount;

  TLR_UINT32  ulCommError;
  TLR_UINT32  ulStaLedState;
  TLR_UINT32  ulErrLedState;

  TLR_UINT32  ulIoByteCnt;

  TLR_UINT32  aulReserved[3];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_EXTENDED_STATE_Ttag</code> */
typedef struct CCLINK_SLAVE_EXTENDED_STATE_Ttag
  CCLINK_SLAVE_EXTENDED_STATE_T;

#define CCLINK_SLAVE_EXT_STATE_FLAG_WDG 0x00000001L
#define CCLINK_SLAVE_EXT_STATE_CTRL     0x00000002L
#define CCLINK_SLAVE_EXT_STATE_NRDY     0x00000004L

__PACKED_PRE struct CCLINK_SLAVE_EXTENDED_STATE_Ttag
{
  TLR_UINT32 ulFlags;

  TLR_UINT32 ulMasterState;
  TLR_UINT32 ulSlaveState;

  TLR_UINT32 ulRxByteCount;
  TLR_UINT32 ulRWrByteCount;

  TLR_UINT32 ulRyByteCount;
  TLR_UINT32 ulRWwByteCount;

  TLR_UINT32 ulSqErrorCount;

  TLR_UINT32 ulCommErrorCnt;
  TLR_UINT32 ulLastCommError;
  TLR_UINT32 ulAddCommErrorInfo;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_APP_REGISTER_REQ_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_APP_REGISTER_REQ_DATA_Ttag
  CCLINK_SLAVE_APP_REGISTER_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_APP_REGISTER_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_APP_REGISTER_CNF_DATA_Ttag
  CCLINK_SLAVE_APP_REGISTER_CNF_DATA_T;

__PACKED_PRE struct CCLINK_SLAVE_APP_REGISTER_REQ_DATA_Ttag
{
  TLR_UINT8 ulReserved;

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_APP_REGISTER_CNF_DATA_Ttag
{
  TLR_UINT8 ulReserved;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_INITIALIZE_REQ_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_INITIALIZE_REQ_DATA_Ttag
  CCLINK_SLAVE_INITIALIZE_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_INITIALIZE_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_INITIALIZE_CNF_DATA_Ttag
  CCLINK_SLAVE_INITIALIZE_CNF_DATA_T;

/** Structure of task command delete configuration CCLINKrequest data */
__PACKED_PRE struct CCLINK_SLAVE_INITIALIZE_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved; /* Reserved fur further use */

}__PACKED_POST;

/** Structure of task command delete configuration confirmation data */
__PACKED_PRE struct CCLINK_SLAVE_INITIALIZE_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved; /* Reserved fur further use */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_GET_BUFFER_HANDLE_REQ_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_GET_BUFFER_HANDLE_REQ_DATA_Ttag
  CCLINK_SLAVE_GET_BUFFER_HANDLE_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_GET_BUFFER_HANDLE_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_GET_BUFFER_HANDLE_CNF_DATA_Ttag
  CCLINK_SLAVE_GET_BUFFER_HANDLE_CNF_DATA_T;

#define CCLINK_SLAVE_MAX_BIT_DATA         112
#define CCLINK_SLAVE_MAX_REGISTER_DATA    256

#define CCLINK_SLAVE_SEND_RECV_BUFFER_SIZE \
  (CCLINK_SLAVE_MAX_BIT_DATA + CCLINK_SLAVE_MAX_REGISTER_DATA)

__PACKED_PRE struct CCLINK_SLAVE_GET_BUFFER_HANDLE_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_GET_BUFFER_HANDLE_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved;

  TLR_UINT32 ulRecvBuffer;
  TLR_UINT32 ulSendBuffer;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_SET_BUS_PARAM_REQ_DATA_T</code> */
typedef struct CCLINK_SLAVE_SET_BUS_PARAM_REQ_DATA_Ttag
  CCLINK_SLAVE_SET_BUS_PARAM_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_SET_BUS_PARAM_CNF_DATA_T</code> */
typedef struct CCLINK_SLAVE_SET_BUS_PARAM_CNF_DATA_Ttag
  CCLINK_SLAVE_SET_BUS_PARAM_CNF_DATA_T;

__PACKED_PRE struct CCLINK_SLAVE_SET_BUS_PARAM_REQ_DATA_Ttag
{
  CCLINK_SLAVE_BUS_PARAM_T tBusParam;
  CCLINK_SLAVE_ADD_PARAM_T tAddParam;

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_SET_BUS_PARAM_CNF_DATA_Ttag
{
  CCLINK_SLAVE_BUS_PARAM_T tBusParam;
  CCLINK_SLAVE_ADD_PARAM_T tAddParam;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_GET_BUS_PARAM_CNF_DATA_T</code> */
typedef struct CCLINK_SLAVE_GET_BUS_PARAM_CNF_DATA_Ttag
  CCLINK_SLAVE_GET_BUS_PARAM_CNF_DATA_T;

__PACKED_PRE struct CCLINK_SLAVE_GET_BUS_PARAM_CNF_DATA_Ttag
{
  CCLINK_SLAVE_BUS_PARAM_T tBusParam;
  CCLINK_SLAVE_ADD_PARAM_T tAddParam;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_STARTSTOP_REQ_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_STARTSTOP_REQ_DATA_Ttag
  CCLINK_SLAVE_STARTSTOP_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_STARTSTOP_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_STARTSTOP_CNF_DATA_Ttag
  CCLINK_SLAVE_STARTSTOP_CNF_DATA_T;

#define CCLINK_SLAVE_STOP_CCLINK     0x00000000L
#define CCLINK_SLAVE_START_CCLINK    0x00000001L

/** Structure of task command start/stop CCLINK request data */
__PACKED_PRE struct CCLINK_SLAVE_STARTSTOP_REQ_DATA_Ttag
{
  TLR_UINT32 ulMode;          /* Start or stop CC-Link        */

}__PACKED_POST;

/** Structure of task command start/stop CCLINK confirmation data */
__PACKED_PRE struct CCLINK_SLAVE_STARTSTOP_CNF_DATA_Ttag
{
  TLR_UINT32 ulMode;          /* Start or stop CC-Link */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_GET_CCL_STATUS_REQ_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_GET_CCL_STATUS_REQ_DATA_Ttag
  CCLINK_SLAVE_GET_CCL_STATUS_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_GET_CCL_STATUS_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_GET_CCL_STATUS_CNF_DATA_Ttag
  CCLINK_SLAVE_GET_CCL_STATUS_CNF_DATA_T;

/** Structure of task command start/stop CCLINK request data */
__PACKED_PRE struct CCLINK_SLAVE_GET_CCL_STATUS_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved;          /* Reserved for further use*/

}__PACKED_POST;

#define CCLINK_SLAVE_CCL_MASTER_ST1_MAS_STAT_USER_APP_PRG_MSK         0x00000001L
#define CCLINK_SLAVE_CCL_MASTER_ST1_MAS_STAT_USER_APP_PRG_ERR_CHK_MSK 0x00000002L
#define CCLINK_SLAVE_CCL_MASTER_ST1_REFRESH_STARTUP_MSK               0x00000004L
#define CCLINK_SLAVE_CCL_MASTER_ST1_TRANSIENT_DATA_STATUS_MSK         0x00000008L
#define CCLINK_SLAVE_CCL_MASTER_ST1_TRANSIENT_DATA_RECEPTION_EN_MSK   0x00000010L
#define CCLINK_SLAVE_CCL_MASTER_ST1_PROTOCOL_VERSION_MSK              0x00000060L
#define CCLINK_SLAVE_CCL_MASTER_ST1_MASTER_STATION_TYPE_MSK           0x00000080L
#define CCLINK_SLAVE_CCL_MASTER_ST2_RY_INFO_TRANSMISSION_POINTS_MSK   0x00000F00L
#define CCLINK_SLAVE_CCL_MASTER_ST2_RWW_INFO_TRANSMISSION_POINTS_MSK  0x0000F000L

#define CCLINK_SLAVE_CCL_SLAVE_ST1_FUSE_STATUS_MSK                    0x00000001L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_UNIT_ERROR_INVAL_NUM_OF_POINTS_MSK 0x00000002L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_NO_REFRESH_RECEIVE_MSK             0x00000004L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_NO_PARAMETER_RECEIVE_MSK           0x00000008L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_SWITCH_CHANGE_DETECTION_MSK        0x00000010L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_CYCLIC_COMMUNICATION_MSK           0x00000020L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_RES1_MSK                           0x00000040L
#define CCLINK_SLAVE_CCL_SLAVE_ST1_WDT_ERROR_MSK                      0x00000080L

#define CCLINK_SLAVE_CCL_SLAVE_ST2_TRANSIENT_DATA_STATUS_MSK          0x00000100L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_TRANSIENT_DATA_RECEPTION_EN_MSK    0x00000200L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_TRANSIENT_TYPE_MSK                 0x00000400L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_RES2_MSK                           0x00000800L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_TRANSMISSION_ROUTE_STATUS_MSK      0x00001000L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_RES_FIXED_TO_ONE_MSK               0x00002000L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_EXTENDED_CYCLE_SETTING_MSK         0x0000C000L

#define CCLINK_SLAVE_CCL_SLAVE_ST2_EXTENDED_CYCLE_SINGLE_MSK          0x00000000L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_EXTENDED_CYCLE_DOUBLE_MSK          0x00004000L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_EXTENDED_CYCLE_QUADRUPLE_MSK       0x00008000L
#define CCLINK_SLAVE_CCL_SLAVE_ST2_EXTENDED_CYCLE_OCTUPLE_MSK         0x0000C000L

/** Structure of task command start/stop CCLINK confirmation data */
__PACKED_PRE struct CCLINK_SLAVE_GET_CCL_STATUS_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved;          /* Reserved for further use */
  TLR_UINT32 ulMasterState;       /* CC-Link Master state     */
  TLR_UINT32 ulSlaveState;        /* CC-Link Slave state      */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_CHANGE_SLAVE_STATUS_REQ_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_CHANGE_SLAVE_STATUS_REQ_DATA_Ttag
  CCLINK_SLAVE_CHANGE_SLAVE_STATUS_REQ_DATA_T;
/** type of <code>CCLINK_SLAVE_CHANGE_SLAVE_STATUS_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_CHANGE_SLAVE_STATUS_CNF_DATA_Ttag
  CCLINK_SLAVE_CHANGE_SLAVE_STATUS_CNF_DATA_T;

#define CCLINK_SLAVE_EVAL_FUSE_STATE_PARAM_MSK      0x00000001L
#define CCLINK_SLAVE_EVAL_SWITCH_CHANGE_PARAM_MSK   0x00000002L
#define CCLINK_SLAVE_EVAL_WATCHDOG_ERROR_PARAM_MSK  0x00000004L

/** Structure of task command change slave state request data */
__PACKED_PRE struct CCLINK_SLAVE_CHANGE_SLAVE_STATUS_REQ_DATA_Ttag
{
  TLR_UINT32  ulFlags;

  TLR_BOOLEAN32 fFuseStatus;
  TLR_BOOLEAN32 fSwitchChange;
  TLR_BOOLEAN32 fWatchdogError;

}__PACKED_POST;

/** Structure of task command change slave state confirmation data */
__PACKED_PRE struct CCLINK_SLAVE_CHANGE_SLAVE_STATUS_CNF_DATA_Ttag
{
  TLR_UINT32 ulFlags;

  TLR_BOOLEAN32 fFuseStatus;
  TLR_BOOLEAN32 fSwitchChange;
  TLR_BOOLEAN32 fWatchdogError;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_STATE_CHANGE_IND_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_STATE_CHANGE_IND_DATA_Ttag
  CCLINK_SLAVE_STATE_CHANGE_IND_DATA_T;

__PACKED_PRE struct CCLINK_SLAVE_STATE_CHANGE_IND_DATA_Ttag
{
  CCLINK_SLAVE_SLAVE_STATE_T     tSlaveState;
  CCLINK_SLAVE_EXTENDED_STATE_T  tExtendedState;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_GET_IO_INFO_CNF_DATA_Ttag</code> */
typedef struct CCLINK_SLAVE_GET_IO_INFO_CNF_DATA_Ttag
  CCLINK_SLAVE_GET_IO_INFO_CNF_DATA_T;

__PACKED_PRE struct CCLINK_SLAVE_GET_IO_INFO_CNF_DATA_Ttag
{
  TLR_UINT32 ulSendDataCnt;     /* Send data count    */
  TLR_UINT32 ulRecvDataCnt;     /* Receice data count */

}__PACKED_POST;

/*************************************************************************************/

/** @} */

/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_APP_REGISTER_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_APP_REGISTER_REQ_Ttag
  CCLINK_SLAVE_PACKET_APP_REGISTER_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_APP_REGISTER_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_APP_REGISTER_CNF_Ttag
  CCLINK_SLAVE_PACKET_APP_REGISTER_CNF_T;

/** Structure of task command application register request*/
__PACKED_PRE struct CCLINK_SLAVE_PACKET_APP_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                  tHead;  /** packet header.       */
  CCLINK_SLAVE_APP_REGISTER_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand application register confirmation */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_APP_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                  tHead; /** packet header.            */
  CCLINK_SLAVE_APP_REGISTER_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_INITIALIZE_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_INITIALIZE_REQ_Ttag
  CCLINK_SLAVE_PACKET_INITIALIZE_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_INITIALIZE_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_INITIALIZE_CNF_Ttag
  CCLINK_SLAVE_PACKET_INITIALIZE_CNF_T;

/** Structure of task command delete configuration request */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_INITIALIZE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;  /** packet header.       */
  CCLINK_SLAVE_INITIALIZE_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand delete configuration confirmation */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_INITIALIZE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                tHead;  /** packet header.            */
  CCLINK_SLAVE_INITIALIZE_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_REQ_Ttag
  CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_CNF_Ttag
  CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_CNF_T;

struct CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;  /** packet header.            */
  CCLINK_SLAVE_GET_BUFFER_HANDLE_REQ_DATA_T tData;  /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_BUFFER_HANDLE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;  /** packet header.            */
  CCLINK_SLAVE_GET_BUFFER_HANDLE_CNF_DATA_T tData;  /** packet request data.      */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_SET_BUS_PARAM_REQ_T</code> */
typedef struct CCLINK_SLAVE_PACKET_SET_BUS_PARAM_REQ_Ttag
  CCLINK_SLAVE_PACKET_SET_BUS_PARAM_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_SET_BUS_PARAM_CNF_T</code> */
typedef struct CCLINK_SLAVE_PACKET_SET_BUS_PARAM_CNF_Ttag
  CCLINK_SLAVE_PACKET_SET_BUS_PARAM_CNF_T;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_SET_BUS_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead; /** packet header */
  CCLINK_SLAVE_SET_BUS_PARAM_REQ_DATA_T tData; /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_SET_BUS_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead; /** packet header */
  CCLINK_SLAVE_SET_BUS_PARAM_CNF_DATA_T tData; /** packet data   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_GET_BUS_PARAM_REQ_T</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_BUS_PARAM_REQ_Ttag
  CCLINK_SLAVE_PACKET_GET_BUS_PARAM_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_GET_BUS_PARAM_CNF_T</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_BUS_PARAM_CNF_Ttag
  CCLINK_SLAVE_PACKET_GET_BUS_PARAM_CNF_T;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_BUS_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_BUS_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead; /** packet header */
  CCLINK_SLAVE_GET_BUS_PARAM_CNF_DATA_T tData; /** packet data   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_STARTSTOP_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_STARTSTOP_REQ_Ttag
  CCLINK_SLAVE_PACKET_STARTSTOP_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_STARTSTOP_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_STARTSTOP_CNF_Ttag
  CCLINK_SLAVE_PACKET_STARTSTOP_CNF_T;

/** Structure of task command start/stop CC-Link request */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_STARTSTOP_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;  /** packet header.       */
  CCLINK_SLAVE_STARTSTOP_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task command start/stop CC-Link confirmation */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_STARTSTOP_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;  /** packet header.            */
  CCLINK_SLAVE_STARTSTOP_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_GET_CCL_STATUS_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_CCL_STATUS_REQ_Ttag
  CCLINK_SLAVE_PACKET_GET_CCL_STATUS_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_GET_CCL_STATUS_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_CCL_STATUS_CNF_Ttag
  CCLINK_SLAVE_PACKET_GET_CCL_STATUS_CNF_T;

/** Structure of task command start/stop CC-Link request */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_CCL_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead;  /** packet header.       */
  CCLINK_SLAVE_GET_CCL_STATUS_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task command start/stop CC-Link confirmation */
__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_CCL_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                    tHead;  /** packet header.            */
  CCLINK_SLAVE_GET_CCL_STATUS_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag
  CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag
  CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_T;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_REQ_Ttag
  CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_CNF_Ttag
  CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_CNF_T;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;  /** packet header.          */
  CCLINK_SLAVE_CHANGE_SLAVE_STATUS_REQ_DATA_T tData;  /** packet request data.   */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_CHANGE_SLAVE_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;  /** packet header.            */
  CCLINK_SLAVE_CHANGE_SLAVE_STATUS_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_STATE_CHANGE_IND_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_STATE_CHANGE_IND_Ttag
  CCLINK_SLAVE_PACKET_STATE_CHANGE_IND_T;
/** type of <code>CCLINK_SLAVE_PACKET_STATE_CHANGE_RES_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_STATE_CHANGE_RES_Ttag
  CCLINK_SLAVE_PACKET_STATE_CHANGE_RES_T;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_STATE_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T                  tHead;  /** packet header.            */
  CCLINK_SLAVE_STATE_CHANGE_IND_DATA_T tData;  /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_STATE_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CCLINK_SLAVE_PACKET_GET_IO_INFO_REQ_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_IO_INFO_REQ_Ttag
  CCLINK_SLAVE_PACKET_GET_IO_INFO_REQ_T;
/** type of <code>CCLINK_SLAVE_PACKET_GET_IO_INFO_CNF_Ttag</code> */
typedef struct CCLINK_SLAVE_PACKET_GET_IO_INFO_CNF_Ttag
  CCLINK_SLAVE_PACKET_GET_IO_INFO_CNF_T;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_IO_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;                  /** packet header.            */

}__PACKED_POST;

__PACKED_PRE struct CCLINK_SLAVE_PACKET_GET_IO_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header.            */
  CCLINK_SLAVE_GET_IO_INFO_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;

/*************************************************************************************/

/** @} */

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__CCLINK_SLAVE_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __CCLINK_SLAVE_PUBLIC_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/
